/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.mover.RectMover;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ActualSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.CardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.Ticker;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class KoishiSpell
extends ActualSpellCard {
    @Override
    public void tick(CardHolder holder) {
        super.tick(holder);
        Vec3 target = holder.target();
        if (target != null) {
            double t = 0.024 * (double)this.tick;
            double dist = holder.center().m_82554_(target);
            for (int i = 0; i < 10; ++i) {
                this.addLaser(holder, target, t + (double)(i * 17));
            }
            this.homing(holder, dist);
            Vec3 vec = holder.targetVelocity();
            if (dist > 26.0 && vec != null) {
                Vec3 diff;
                Mob mob;
                LivingEntity tar;
                if (dist < 32.0 && holder.random().m_188500_() > 0.2 + 1.0 / (32.0 - dist)) {
                    return;
                }
                this.border(holder, target, vec);
                LivingEntity livingEntity = holder.self();
                if (livingEntity instanceof Mob && (tar = (mob = (Mob)livingEntity).m_5448_()) != null && (diff = tar.m_20182_().m_82546_(holder.center())).m_82553_() > 32.0) {
                    tar.m_20219_(diff.m_82541_().m_82490_(32.0).m_82549_(holder.center()));
                    tar.m_20256_(diff.m_82541_().m_82490_(-1.0));
                    tar.f_19812_ = true;
                    if (tar instanceof Player) {
                        tar.f_19864_ = true;
                    }
                }
            }
        }
    }

    private void homing(CardHolder holder, double dist) {
        if (this.tick % 4 == 0) {
            Vec3 le = holder.target();
            if (le == null) {
                return;
            }
            StateChange ans = new StateChange();
            double a = (double)this.tick * Math.PI / 20.0;
            ans.pos = holder.center();
            ans.front = new Vec3(Math.cos(a), 0.0, Math.sin(a));
            this.addTicker(ans);
        }
        if (this.tick % 10 == 0) {
            double speed = Math.max(0.6, dist / 40.0);
            int n = 24;
            DanmakuHelper.Orientation o0 = DanmakuHelper.getOrientation(holder.forward());
            double rand = holder.random().m_188500_() * 360.0;
            for (int i = 0; i < n; ++i) {
                Vec3 dir = o0.rotateDegrees(360.0 / (double)n * (double)i + rand).m_82490_(speed);
                ItemDanmakuEntity e = holder.prepareDanmaku(40, dir, YHDanmaku.Bullet.BALL, DyeColor.RED);
                holder.shoot(e);
            }
        }
    }

    private void addLaser(CardHolder holder, Vec3 target, double t) {
        double a = 1.47;
        double b = 4.0;
        double c = 3.0;
        double r = 32.0;
        double x0 = r * Math.cos(a * t) * Math.cos(t);
        double z0 = r * Math.cos(a * t) * Math.sin(t);
        double x1 = Math.cos(b * t);
        double z1 = Math.cos(b * t);
        Vec3 pos = holder.center();
        pos = new Vec3(pos.f_82479_ + x0, Math.min(pos.f_82480_ - 15.0, target.f_82480_ - 10.0), pos.f_82481_ + z0);
        Vec3 dir = new Vec3(x1, c, z1).m_82541_();
        ItemLaserEntity e = holder.prepareLaser(40, pos, dir, 60.0f, YHDanmaku.Laser.LASER, DyeColor.BLUE);
        e.setupTime(10, 4, 20, 4);
        holder.shoot(e);
    }

    private void border(CardHolder holder, Vec3 target, Vec3 vel) {
        Vec3 fut = target.m_82549_(vel.m_82490_(4.0));
        Vec3 cen = holder.center();
        double dist = target.m_82554_(cen);
        double min = Math.max(0.0, 32.0 - dist);
        double max = Math.max(min, fut.m_82554_(cen) - dist);
        int n = 4;
        Vec3 dir = fut.m_82546_(cen).m_82541_();
        DanmakuHelper.Orientation o0 = DanmakuHelper.getOrientation(dir).asNormal();
        for (int i = 0; i < n; ++i) {
            double d = holder.random().m_188500_() * (max - min) + min + dist;
            Vec3 pos = dir.m_82490_(d + 0.3).m_82549_(cen);
            Vec3 forward = o0.rotateDegrees(holder.random().m_188500_() * 360.0, -30.0).m_82490_(0.1);
            ItemDanmakuEntity e = holder.prepareDanmaku(40, forward, YHDanmaku.Bullet.CIRCLE, DyeColor.PINK);
            e.m_146884_(pos);
            holder.shoot(e);
        }
    }

    @SerialClass
    public static class StateChange
    extends Ticker<KoishiSpell> {
        @SerialClass.SerialField
        private Vec3 pos;
        @SerialClass.SerialField
        private Vec3 front;
        @SerialClass.SerialField
        private int r0 = 4;
        @SerialClass.SerialField
        private int t0 = 20;
        @SerialClass.SerialField
        private int t2 = 40;
        @SerialClass.SerialField
        private int dt = 20;
        @SerialClass.SerialField
        private double termSpeed = 1.0;
        @SerialClass.SerialField
        private double dr = 20.0;

        @Override
        public boolean tick(CardHolder holder, KoishiSpell card) {
            this.step(holder);
            super.tick(holder, card);
            return false;
        }

        private void step(CardHolder holder) {
            ItemDanmakuEntity e;
            Vec3 le = holder.target();
            if (le == null) {
                return;
            }
            RandomSource r = holder.random();
            if (this.front == null) {
                this.pos = holder.center();
                this.front = le.m_82546_(holder.center()).m_82541_();
            }
            if (this.tick < 0) {
                return;
            }
            if (this.tick == 0) {
                double acc = (double)this.r0 * 2.0 / (double)this.t0 / (double)this.t0;
                Vec3 vec = this.front.m_82490_(acc * (double)this.t0);
                e = holder.prepareDanmaku(this.t0, vec, YHDanmaku.Bullet.MENTOS, DyeColor.RED);
                e.mover = new RectMover(this.pos, vec, this.front.m_82490_(-acc));
                holder.shoot(e);
            }
            if (this.tick == this.t0) {
                Vec3 p0 = this.pos.m_82549_(this.front.m_82490_((double)this.r0));
                Vec3 vec = le.m_82546_(p0).m_82541_().m_82490_(this.termSpeed);
                int t = this.t2 + r.m_188503_(this.dt);
                e = holder.prepareDanmaku(t, vec, YHDanmaku.Bullet.MENTOS, DyeColor.RED);
                e.m_146884_(p0);
                e.mover = new RectMover(p0, vec, Vec3.f_82478_);
                holder.shoot(e);
            }
        }
    }
}

